/*=============================================================================
 MessageWindowPopup_KuroCustom.js 
----------------------------------------------------------------------------

/*:
 * @plugindesc  パッシブスキル くろあめ工房カスタム
 * @author くろあめ
 * @target MZ
 *
 * @help NUUNさんのパッシブスキルプラグインで適用する、武器のメモ欄に記載されている
 * 必殺倍率などの、くろあめ工房製の概念を正しく計算・反映されるよう修正します。
 */

(() => {

    /* アクターのクリティカル倍率増幅値取得 */
    const _Game_Actor_getCriMagniBst_PassiveSkill = Game_Actor.prototype.getCriMagniBst;
    Game_Actor.prototype.getCriMagniBst = function() {
        fullMagni = _Game_Actor_getCriMagniBst_PassiveSkill.apply(this, arguments);
        passiveSkills = this.passiveObject();
        if(passiveSkills){
            for (let i = 0; i < passiveSkills.length; i++) {
                if (passiveSkills[i] && passiveSkills[i].meta && passiveSkills[i].meta.CriMagniBst) fullMagni += Number(passiveSkills[i].meta.CriMagniBst);
            }
        }
        return fullMagni;
    };

    /* アクターの属性倍率増幅値取得 */
    const _Game_Actor_getElmMagniBst_PassiveSkill = Game_Actor.prototype.getElmMagniBst;
    Game_Actor.prototype.getElmMagniBst = function(elmId) {
        
        lastMagni = _Game_Actor_getElmMagniBst_PassiveSkill.apply(this, arguments);
        
        passiveSkills = this.passiveObject();
        if(passiveSkills){
            for (let i = 0; i < passiveSkills.length; i++) {      
                if (passiveSkills[i] && passiveSkills[i].meta && passiveSkills[i].meta.ElmMagniBst){
                    getMeta = passiveSkills[i].meta.ElmMagniBst.split(',');
                    if(getMeta[0] == elmId) lastMagni += Number(getMeta[1]);
                }
            }
        }
        return lastMagni;
    };

})();
